<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <title lang="en">Výpis směrového řešení</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <h2 lang="en">Výpis směrového řešení</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>

              <xsl:for-each select="GeometryProject">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Projekt:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Popis:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@description"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Název souboru:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@file"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Poslední revize:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                        <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                        pokud není specifikováno jinak.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>

                <table class="margin" width="90%">
                  <colgroup span="5">
                    <col width="18%"/>
                    <col width="13%"/>
                    <col width="25%"/>
                    <col width="22%"/>
                    <col width="22%"/>
                  </colgroup>
                  <xsl:for-each select="HorizontalAlignment">
                    <tbody>
                      <tr>
                        <th align="right" colspan="2" lang="en">
                          <br />Název trasy:&#xa0;
                        </th>
                        <td align="left" colspan="3" valign="bottom">
                          <xsl:value-of select="@name"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right" colspan="2" lang="en">Popis trasy&#xa0;</th>
                        <td align="left" colspan="3">
                          <xsl:value-of select="@description"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right" colspan="2" lang="en">Styl trasy:&#xa0;</th>
                        <td align="left" colspan="3">
                          <xsl:value-of select="@style"/>
                        </td>
                      </tr>
                      <tr>
                        <th colspan="2"/>
                        <th align="right" class="underline" lang="en">Staničení</th>
                        <th align="right" class="underline" lang="en">Y</th>
                        <th align="right" class="underline" lang="en">X</th>
                      </tr>
                      <xsl:apply-templates/>
                    </tbody>
                  </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="HorizontalLine">
    <tr>
      <td align="left" colspan="5" lang="en">
        <br/>Prvek: Přímá
      </td>
    </tr>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( Start/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="Start/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <xsl:for-each select="StationEquation">
        <tr>
          <td align="right" colspan="2" lang="en">StanPuv</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">StanNov</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:if>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( End/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="End/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@direction))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="HorizontalCircle">
    <tr>
      <td align="left" colspan="5" lang="en">
        <br/>Prvek: Oblouk
      </td>
    </tr>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( Start/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="Start/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
      </td>
    </tr>
    <xsl:if test="PI">
      <tr>
        <td align="right">
          <xsl:value-of select="cif:pointType( string( PI/@pointType ))"/>
        </td>
        <td align="right">
          ( <xsl:value-of select="PI/@name"/> )
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( Center/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="Center/@name"/> )
      </td>
      <td />
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Center/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Center/@easting))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <xsl:for-each select="StationEquation">
        <tr>
          <td align="right" colspan="2" lang="en">StanPuv</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">StanNov</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:if>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( End/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="End/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Úhel:</td>
      <td align="right">
        <xsl:value-of select="cif:angularFormat(number(@delta))"/>
      </td>
      <td align="left" lang="en">
        <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
        <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
      </td>
    </tr>
    <tr>
            <td align="right" colspan="2" lang="en">
                <xsl:choose>
                    <xsl:when test="@curvatureDefinition = 'arc'">
                        Stupeň křivosti (Oblouk):
                    </xsl:when>
                    <xsl:when test="@curvatureDefinition = 'chord'">
                        Stupeň křivosti (Tětiva):
                    </xsl:when>
                    <xsl:otherwise>
                        Stupeň křivosti:
                    </xsl:otherwise>
                </xsl:choose>
            </td>
      <td align="right">
        <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
      </td>
    </tr>
    <tr>
            <td align="right" colspan="2" lang="en">
                <xsl:if test="@curvatureDefinition = 'arc'">
                </xsl:if>
                <xsl:if test="@curvatureDefinition = 'chord'">
                    Délka tětivy:
                </xsl:if>
            </td>
            <td align="right">
                <xsl:if test="@curvatureDefinition = 'arc'">
                </xsl:if>
                <xsl:if test="@curvatureDefinition = 'chord'">
                    <xsl:value-of select="cif:distanceFormat(number(End/station/@internalStation - Start/station/@internalStation))"/>
                </xsl:if>
            </td>
        </tr>
        <tr>
      <td align="right" colspan="2" lang="en">Tečna:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Tětiva:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">zo:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Počáteční směr oblouku:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tětivy:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Koncový směr oblouku:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="HorizontalSpiral">
    <tr>
      <td align="left" colspan="5" lang="en">
        <br/>Prvek:
        <xsl:choose>
          <xsl:when test="@compound = 'false'">
            <xsl:value-of select="@type"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text> Mezilehlá </xsl:text>
            <xsl:value-of select="@type"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( Start/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="Start/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
      </td>
    </tr>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( PI/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="PI/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat( number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <xsl:for-each select="StationEquation">
        <tr>
          <td align="right" colspan="2" lang="en">StanPuv</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">StanNov</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:if>
    <tr>
      <td align="right">
        <xsl:value-of select="cif:pointType( string( End/@pointType ))"/>
      </td>
      <td align="right">
        ( <xsl:value-of select="End/@name"/> )
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Vstupní poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výstupní poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Úhel:</td>
      <td align="right">
        <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
      </td>
      <td lang="en">
        <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
        <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Parametr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@aConstant))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">X:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Y:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">dR:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@p))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Xs:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Vstupní radiální směr:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tětivy:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výstupní radiální směr:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Směr tečny:</td>
      <td align="right">
        <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Pro tento výpis musíte vybrat nejméně jeden Civil prvek směrové geometrie.
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
